<?php
// Complete fix for checkout and admin panel
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "reviewprcom_db";

try {
    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    echo "<h2>🔧 Complete System Fix</h2>";
    
    // Step 1: Drop and recreate orders table with all columns
    echo "<h3>Step 1: Fixing Orders Table Structure</h3>";
    
    $conn->query("DROP TABLE IF EXISTS orders");
    echo "<p>✅ Dropped existing orders table</p>";
    
    $create_orders = "CREATE TABLE orders (
        id INT AUTO_INCREMENT PRIMARY KEY,
        order_id VARCHAR(20) NOT NULL UNIQUE,
        product_id INT DEFAULT NULL,
        product_name VARCHAR(255) NOT NULL,
        price DECIMAL(10,2) NOT NULL,
        quantity INT DEFAULT 1,
        total DECIMAL(10,2) NOT NULL,
        customer_email VARCHAR(100) NOT NULL,
        customer_name VARCHAR(100) DEFAULT NULL,
        review_location TEXT DEFAULT NULL,
        reviews_per_day INT DEFAULT NULL,
        promo_code VARCHAR(50) DEFAULT NULL,
        file_name VARCHAR(255) DEFAULT NULL,
        file_link TEXT DEFAULT NULL,
        customer_notes TEXT DEFAULT NULL,
        status ENUM('pending','processing','completed','cancelled') DEFAULT 'pending',
        order_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_order_id (order_id),
        INDEX idx_customer_email (customer_email),
        INDEX idx_status (status)
    )";
    
    if ($conn->query($create_orders)) {
        echo "<p>✅ Created orders table with all required columns</p>";
    } else {
        echo "<p>❌ Error creating orders table: " . $conn->error . "</p>";
    }
    
    // Step 2: Create sample orders for testing
    echo "<h3>Step 2: Adding Sample Orders</h3>";
    
    $sample_orders = [
        [
            'order_id' => 'ORD-SAMPLE01',
            'product_name' => 'Google Reviews Package',
            'price' => 49.99,
            'total' => 49.99,
            'customer_email' => 'john.doe@example.com',
            'customer_name' => 'John Doe',
            'review_location' => 'John\'s Restaurant',
            'reviews_per_day' => 2,
            'customer_notes' => 'Need reviews for new restaurant opening'
        ],
        [
            'order_id' => 'ORD-SAMPLE02',
            'product_name' => 'Facebook Reviews Boost',
            'price' => 39.99,
            'total' => 79.98,
            'quantity' => 2,
            'customer_email' => 'sarah.smith@example.com',
            'customer_name' => 'Sarah Smith',
            'review_location' => 'Smith Beauty Salon',
            'reviews_per_day' => 3,
            'customer_notes' => 'Urgent - launching new services',
            'status' => 'processing'
        ],
        [
            'order_id' => 'ORD-SAMPLE03',
            'product_name' => 'Trustpilot Professional',
            'price' => 59.99,
            'total' => 59.99,
            'customer_email' => 'mike.johnson@example.com',
            'customer_name' => 'Mike Johnson',
            'review_location' => 'Johnson Tech Solutions',
            'reviews_per_day' => 1,
            'promo_code' => 'SAVE10',
            'customer_notes' => 'B2B software company',
            'status' => 'completed'
        ]
    ];
    
    foreach ($sample_orders as $order) {
        $sql = "INSERT INTO orders (order_id, product_name, price, quantity, total, customer_email, customer_name, review_location, reviews_per_day, promo_code, customer_notes, status) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssdidsssiss", 
            $order['order_id'],
            $order['product_name'], 
            $order['price'],
            $order['quantity'] ?? 1,
            $order['total'],
            $order['customer_email'],
            $order['customer_name'],
            $order['review_location'],
            $order['reviews_per_day'],
            $order['promo_code'] ?? null,
            $order['customer_notes'],
            $order['status'] ?? 'pending'
        );
        
        if ($stmt->execute()) {
            echo "<p>✅ Added sample order: {$order['order_id']}</p>";
        }
    }
    
    // Step 3: Verify table structure
    echo "<h3>Step 3: Verifying Table Structure</h3>";
    $result = $conn->query("DESCRIBE orders");
    echo "<table border='1' style='border-collapse: collapse; width: 100%; margin: 10px 0;'>";
    echo "<tr style='background: #e2e8f0;'><th>Column</th><th>Type</th><th>Null</th><th>Default</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td><strong>" . $row['Field'] . "</strong></td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . ($row['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Step 4: Test order count
    $count_result = $conn->query("SELECT COUNT(*) as count FROM orders");
    $count = $count_result->fetch_assoc()['count'];
    echo "<p>✅ Total orders in database: <strong>$count</strong></p>";
    
    echo "<br><h3>🎉 System Fix Complete!</h3>";
    echo "<p>All database issues have been resolved. Your checkout and admin panel should now work perfectly.</p>";
    
    echo "<div style='margin: 20px 0; padding: 20px; background: #f0f9ff; border-left: 4px solid #3b82f6;'>";
    echo "<h4>✅ What's Fixed:</h4>";
    echo "<ul>";
    echo "<li>✅ Orders table recreated with all required columns</li>";
    echo "<li>✅ customer_name column added</li>";
    echo "<li>✅ All checkout form fields supported</li>";
    echo "<li>✅ Sample orders added for testing</li>";
    echo "<li>✅ Admin panel will show complete customer details</li>";
    echo "</ul>";
    echo "</div>";
    
    echo "<div style='margin: 20px 0;'>";
    echo "<a href='simple-checkout.php?service=Google%20Reviews%20Package&price=49.99' style='background: #3b82f6; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; margin-right: 10px; display: inline-block;'>🛒 Test Checkout</a>";
    echo "<a href='admin_dashboard.php' style='background: #10b981; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; margin-right: 10px; display: inline-block;'>📊 View Admin Panel</a>";
    echo "<a href='index.php' style='background: #6b7280; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; display: inline-block;'>🏠 Main Website</a>";
    echo "</div>";
    
    $conn->close();
    
} catch (Exception $e) {
    echo "<h2>❌ Error</h2>";
    echo "<p style='color: red;'>" . $e->getMessage() . "</p>";
    echo "<p>Please make sure XAMPP MySQL is running.</p>";
}
?>

<style>
body { 
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; 
    max-width: 1000px; 
    margin: 50px auto; 
    padding: 30px;
    background: #f8fafc;
    line-height: 1.6;
}
h2, h3, h4 { color: #1e293b; margin-bottom: 15px; }
p { margin: 8px 0; }
table { width: 100%; margin: 15px 0; }
th, td { padding: 10px; text-align: left; border: 1px solid #d1d5db; }
th { background: #e2e8f0; font-weight: 600; }
ul { margin: 10px 0; padding-left: 20px; }
li { margin: 5px 0; }
</style>
